/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.filesvr;

import com.ibm.hsc.filesvr.FsException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.GregorianCalendar;

public class FsByteStream {
    private static final int DEFAULT_CAPACITY = 32;
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final int SIZEOF_BYTE = 1;
    private static final int SIZEOF_INT = 4;
    private static final int SIZEOF_LONG = 8;
    private static final int SIZEOF_SHORT = 2;
    private byte[] m_buffer = null;
    private int m_position = 0;
    private int m_length = 0;

    public FsByteStream() {
        this.m_buffer = new byte[32];
        this.m_length = 32;
    }

    public FsByteStream(byte[] byArray) throws FsException {
        if (byArray != null) {
            this.m_buffer = byArray;
            this.m_length = byArray.length;
        } else {
            this.m_buffer = new byte[32];
            this.m_length = 32;
        }
    }

    public FsByteStream(byte[] byArray, int n, int n2) throws FsException {
        if (byArray != null && n < byArray.length && n2 > 0) {
            if (n < 0) {
                n = 0;
            }
            if (byArray.length < n + n2) {
                n2 = byArray.length - n;
            }
            this.m_length = n2;
            this.m_buffer = new byte[this.m_length];
            System.arraycopy(byArray, n, this.m_buffer, 0, this.m_length);
        } else {
            this.m_buffer = new byte[32];
            this.m_length = 32;
        }
    }

    protected FsByteStream(int n) throws FsException {
        this.m_buffer = new byte[n];
        this.m_length = n;
    }

    public int available() {
        return this.m_length - this.m_position;
    }

    public void clear() {
        this.m_length = 0;
        this.m_position = 0;
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[this.m_length];
        System.arraycopy(this.m_buffer, 0, byArray, 0, this.m_length);
        return byArray;
    }

    public int getLength() {
        return this.m_length;
    }

    public int getPosition() {
        return this.m_position;
    }

    public void extend(int n) {
        if (this.m_buffer.length < n) {
            int n2;
            if (n > 0x40000000) {
                n2 = 0x40000000;
            } else {
                for (n2 = 1; n2 < n; n2 *= 2) {
                }
            }
            byte[] byArray = this.m_buffer;
            this.m_buffer = new byte[n2];
            System.arraycopy(byArray, 0, this.m_buffer, 0, this.m_length);
        }
    }

    public void print() {
        FsByteStream.print(this.m_buffer, 0, this.m_length < 128 ? this.m_length : 128);
    }

    public static void print(byte[] byArray) {
        if (byArray != null) {
            FsByteStream.print(byArray, 0, byArray.length);
        }
    }

    public static void print(byte[] byArray, int n, int n2) {
        int n3 = 16;
        int n4 = 9;
        int n5 = 9;
        if (byArray == null || byArray.length < n) {
            return;
        }
        int n6 = byArray.length - n;
        int n7 = n2 < n6 ? n2 : n6;
        int n8 = (n2 + n3 - 1) / n3;
        for (int i = n; i < n8; ++i) {
            System.out.print("     ");
            String string = new String();
            for (int j = 0; j < n3; ++j) {
                int n9 = i * n3 + j;
                try {
                    int n10 = byArray[n9];
                    byte by = (byte)(n10 >> 4 & 0xF);
                    byte by2 = (byte)(n10 & 0xF);
                    if (by <= 9) {
                        System.out.print(by);
                    } else {
                        System.out.print((char)(65 + by - 10));
                    }
                    if (by2 <= 9) {
                        System.out.print(by2);
                    } else {
                        System.out.print((char)(65 + by2 - 10));
                    }
                    if ((char)n10 < '!' || '~' < (char)n10) {
                        n10 = 32;
                    }
                    string = string + (char)n10;
                }
                catch (Exception exception) {
                    System.out.print("  ");
                    string = string + " ";
                }
                if ((j + 1) % 4 != 0) continue;
                System.out.print(" ");
            }
            while (string.length() < 16) {
                string = string + " ";
            }
            System.out.println("  | " + string + " |");
        }
    }

    protected byte readByte() throws FsException {
        return (byte)this.readLong(1);
    }

    protected void readBytes(byte[] byArray) throws FsException {
        if (byArray != null) {
            this.readBytes(byArray, 0, byArray.length);
        }
    }

    protected void readBytes(byte[] byArray, int n, int n2) throws FsException {
        int n3 = this.m_position + n2;
        if (this.m_length < n3) {
            throw new FsException(17, (long)this.m_length, (long)n3);
        }
        int n4 = 0;
        while (n4 < n2) {
            byArray[n4] = this.m_buffer[this.m_position];
            ++n4;
            ++this.m_position;
        }
    }

    protected GregorianCalendar readDate() throws FsException {
        return new GregorianCalendar(this.readInt(2), this.readInt(1) - 1, this.readInt(1), this.readInt(1), this.readInt(1), this.readInt(1));
    }

    protected int readInt() throws FsException {
        return (int)this.readLong(4);
    }

    protected int readInt(int n) throws FsException {
        return (int)this.readLong(n <= 4 ? n : 4);
    }

    protected long readLong() throws FsException {
        return this.readLong(8);
    }

    protected long readLong(int n) throws FsException {
        int n2;
        long l = 0L;
        if (n > 8) {
            n = 8;
        }
        if (this.m_length < (n2 = this.m_position + n)) {
            throw new FsException(17, (long)this.m_length, (long)n2);
        }
        while (this.m_position < n2) {
            l <<= 8;
            l += (long)this.m_buffer[this.m_position] & 0xFFL;
            ++this.m_position;
        }
        return l;
    }

    protected short readShort() throws FsException {
        return (short)this.readLong(2);
    }

    protected short readShort(int n) throws FsException {
        return (short)this.readLong(n <= 2 ? n : 2);
    }

    protected String readString(int n) throws FsException {
        try {
            String string = new String(this.m_buffer, this.m_position, n, DEFAULT_ENCODING);
            this.m_position += n;
            return string;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public void setPosition(int n) {
        this.m_position = n < 0 ? 0 : (n < this.m_length ? n : this.m_length);
    }

    public void reset() {
        this.m_position = 0;
    }

    protected void writeByte(byte by) {
        this.writeLong(by, 1);
    }

    protected void writeBytes(byte[] byArray) {
        if (byArray != null) {
            this.writeBytes(byArray, 0, byArray.length);
        }
    }

    protected void writeBytes(byte[] byArray, int n, int n2) {
        int n3;
        if (byArray == null || byArray.length < n) {
            return;
        }
        if (byArray.length < n + n2) {
            n2 = byArray.length - n;
        }
        if (this.m_buffer.length < (n3 = this.m_position + n2)) {
            this.extend(n3);
        }
        int n4 = 0;
        while (n4 < n2) {
            this.m_buffer[this.m_position] = byArray[n4];
            ++n4;
            ++this.m_position;
        }
        if (this.m_position > this.m_length) {
            this.m_length = this.m_position;
        }
    }

    protected void writeDate(GregorianCalendar gregorianCalendar) {
        this.writeInt(gregorianCalendar.get(1), 2);
        this.writeInt(gregorianCalendar.get(2) + 1, 1);
        this.writeInt(gregorianCalendar.get(5), 1);
        this.writeInt(gregorianCalendar.get(11), 1);
        this.writeInt(gregorianCalendar.get(12), 1);
        this.writeInt(gregorianCalendar.get(13), 1);
    }

    protected void writeInt(int n) {
        this.writeLong(n, 4);
    }

    protected void writeInt(int n, int n2) {
        this.writeLong(n, n2 <= 4 ? n2 : 4);
    }

    protected void writeLong(long l) {
        this.writeLong(l, 8);
    }

    protected void writeLong(long l, int n) {
        int n2;
        if (n > 8) {
            n = 8;
        }
        if (this.m_buffer.length < (n2 = this.m_position + n)) {
            this.extend(n2);
        }
        int n3 = n2 - 1;
        while (n3 >= this.m_position) {
            this.m_buffer[n3] = (byte)(l & 0xFFL);
            --n3;
            l >>= 8;
        }
        this.m_position += n;
        if (this.m_position > this.m_length) {
            this.m_length = this.m_position;
        }
    }

    protected void writeShort(short s) {
        this.writeLong(s, 2);
    }

    protected void writeShort(short s, int n) {
        this.writeLong(s, n <= 2 ? n : 2);
    }

    protected void writeString(String string) {
        this.writeString(string, string.length());
    }

    protected void writeString(String string, int n) {
        try {
            int n2;
            byte[] byArray = string.getBytes(DEFAULT_ENCODING);
            if (byArray.length < n) {
                n = byArray.length;
            }
            if (this.m_buffer.length < (n2 = this.m_position + n)) {
                this.extend(n2);
            }
            for (int i = 0; i < n; ++i) {
                this.m_buffer[i + this.m_position] = byArray[i];
            }
            this.m_position += n;
            if (this.m_position > this.m_length) {
                this.m_length = this.m_position;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    protected void writeTo(OutputStream outputStream) throws FsException {
        try {
            outputStream.write(this.m_buffer, 0, this.m_position);
        }
        catch (IOException iOException) {
            throw new FsException(768, (Object)iOException);
        }
    }
}

